<?php
/*------------------------------------------------
 * Конвертер YML от prom.ua для gmc     2020-09-19
 * Copyright © FinBoss 2020
 * finboss.ua@gmail.com 
 *
 * вывод параметров
 *
 * License: Commercial open source software (COSS) 
 *------------------------------------------------
 */

@set_time_limit(0);

error_reporting (E_ALL);

header('Content-Type: text/html; charset=utf-8');

// контроль доступа по IP
$a_allow = false;
$a_ips = '';
if (is_file('.allowed_ip')){
	$a_ips = file('.allowed_ip');
}elseif (is_file('../.allowed_ip')){
	$a_ips = file('../.allowed_ip');
}

if (is_array($a_ips)){
	
	foreach ($a_ips as $a_ip){
		$a_ip = trim($a_ip);
		if (strpos($a_ip, '*') !== false){
			
			// process 127.0.*.*
			
			$remote = explode('.', $_SERVER['REMOTE_ADDR']);
			$a = explode('.', $a_ip);
			
			$true_count = 0;
			for ($i=0;$i<4;$i++){
				switch ($i){
					case 0:
					case 1:
						if ($remote[$i] != $a[$i]){
							break 2;
						}else{
							$true_count++;
						}
						break;
					case 2:
					case 3:
						if ($a[$i] == '*'){
							// пропускаем
							$true_count++;
						}else{
							if ($remote[$i] != $a[$i]){
								break 2;
							}else{
								$true_count++;
							}
						}
						
				}
			}
			if ($true_count == 4){
				$a_allow = true;
				break;
			}
			
		}else{
			if ($_SERVER['REMOTE_ADDR'] == trim($a_ip)){
				$a_allow = true;
				break;
			}
		}
	}
	
}
if ($a_allow === false){
	die('доступ для IP '.$_SERVER['REMOTE_ADDR'].' заблокирован');
}


function curl_get_contents($url, array $get = array(), array $options = array())
{
	
	$defaults = array(
			CURLOPT_URL => $url. (strpos($url, '?') === FALSE ? '?' : ''). http_build_query($get),
			CURLOPT_HEADER => 0,
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_FOLLOWLOCATION => 1,
			CURLOPT_TIMEOUT => 300,
			CURLOPT_HTTPHEADER => array('Accept: application/json'),
			CURLOPT_SSL_VERIFYPEER => false
	);
	
	$ch = curl_init();
	curl_setopt_array($ch, ($options + $defaults));
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 GTB5');
	if(!$result = curl_exec($ch)) {
		trigger_error(curl_error($ch));
		$result = 'Error: '.curl_error($ch);
	}else{
		//echo 'OK';
	}
	curl_close($ch);
	
	return $result;
}

date_default_timezone_set ('Europe/Kiev');

include_once('converter_prom_to_gmc.cfg.php');

$title = "Просмотр параметров входного XML файла";
	
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf8" >
<title><?php echo $title?></title>

</head>
<body style="font-family:Trebuchet MS; font-size: 10pt;" bgcolor="#f5f8fb">

<table width="100%" bgcolor="#416e98">
<tr valign="middle">
<td><span style="font-size:25px; color:#FFF; font-family:Trebuchet MS"><?php echo $title?></span></td>
<td align="right"><span style="font-size:15px; color:#FFF; font-family:Trebuchet MS"></span></td>
</tr>
</table>

<?php 

	
	
	if (!is_file('input/prom.xml') OR (isset($_GET['mode']) AND $_GET['mode'] == 'reload')){

		// 'Файл input/prom.xml не найден - скачиваем';

		$string = curl_get_contents($site_protocol_select.'://'.$xml_link);
		
		if (strpos($string, 'Error: ') !== false){
			die("Ошибка: не удалось получить данные по ссылке ".$xml_link." ответ = $string ".date(" Y-m-d H:i:s"));
		}else if ($string == ''){
			die("Ошибка: не удалось получить данные по ссылке - получен пустой ответ".$xml_link.date(" Y-m-d H:i:s"));
		}else{
			file_put_contents('input/prom.xml', $string);
			unset($string);
			$data = simplexml_load_file('input/prom.xml');
			if (!is_object ($data)){
				die("Ошибка: не удалось получить данные по ссылке ".$xml_link." ответ см. в файле input/prom.xml ".date(" Y-m-d H:i:s"));
			}
			$size = filesize('input/prom.xml');
		}
	}else{
		
		$size = filesize('input/prom.xml');
		$data = simplexml_load_file('input/prom.xml');
		if (is_object($data)){
			
		}else{
			die ('Файл input/prom.xml содержит ошибки');
			
		}
		
	}
	
	$date = $data->attributes()->date;
	$categories_in_file = $data->shop->categories->category;
	$offers = $data->shop->offers->offer;
	echo "<br/><center>\r\n";
	echo "Используется входной файл, сгенерированный $date <br/>\r\n";
	echo "Размер файла $size <br/>\r\n";
	echo "Всего категорий ".count($categories_in_file)." <br/>\r\n";
	echo "Всего товаров ".count($offers)." <br/><br/>\r\n";
	
	echo "<a href='set_parameters.php?mode=reload&token=".time()."'><b>ОБНОВИТЬ</b></a> <br/><br/>\r\n";
	echo "<hr/>\r\n";
	echo "</center>\r\n";


	

	$parameters_in_file = array();
	$products = $values = array();
	foreach ($data->shop->offers->offer as $item){
		
		$products[] = (string)$item->vendorCode;
		
		if (isset($item->param)){
		
			if (count($item->param) > 1){
			
				foreach ($item->param as $param){
					$param_name = trim((string)$param->attributes()->name);
					if (!isset($parameters_in_file[$param_name])){
						$parameters_in_file[$param_name] = trim((string)$item->name);
					}
					
					$values[$param_name][(string)$param] = 1;
					
				}
			
			}else{
				
				$param_name = trim((string)$item->param->attributes()->name);
				
				if (!isset($parameters_in_file[$param_name])){
					$parameters_in_file[$param_name] = (string)$item->name;
				}
				
				$values[$param_name][(string)$item->param] = 1;
			}
		}
	}
	
	ksort($parameters_in_file);
	

	foreach ($values as $param_name => $values_array){
?>
<h2><?php echo $param_name; ?></h2>

<?php 
		ksort($values_array);
		
		foreach ($values_array as $value => $dummy){
			echo $value.'<br/>';
		}
	}

?>
<h2>Товары</h2>
<?php 
sort($products);

foreach ($products as $product){
	echo $product.'<br/>';
}
	
?>
</body>
</html>
